# Fourier Compressed Sensing Project

## Overview
This project addresses the Fourier compressed sensing problem using a pretrained diffusion model. The objective is to reconstruct images from a limited number of measurements by exploiting the signal's sparsity in the Fourier domain.

## Features
- Signal reconstruction via Fourier compressed sensing
- Implementation of Fourier transforms
- Sparse signal recovery using the Diffusion Posterior Sampling algorithm

## Requirements
To run the code, activate the conda environment `ee367-project`:
```bash
conda activate ee367-project
```

## Code Explanation
1. `generate_mask.ipynb`: Generates undersampling masks for Fourier compressed sensing, including variable-density Poisson-disc, uniform, and Gaussian sampling patterns.
2. `dps_stablediffusion.py`: Main script for applying the MRI forward operator to generate measurements from ground truth and solving the inverse problem using the Diffusion Posterior Sampling method with a pretrained diffusion model (Stable Diffusion v2.1-base).

## Examples
Run the main script to perform the DPS algorithm for Fourier compressed sensing:
```bash
python dps_stablediffusion.py
```
Results are saved in the `./result` directory.

Several options (e.g., `mask_type`, `image_type`, `acceleration`) allow for different experiments. Refer to `dps_stablediffusion.py` for details.

Example usage:
```bash
python dps_stablediffusion.py --mask_type 'gaussian' --image_type 'knee' --acceleration 10
```

## Contact
For questions or inquiries, contact Jaehyeok Bae at jhbae110@stanford.edu.
